library dotNetAssembly;

(*
To export routines from an assembly. modify IL as follows and reassemble:
 - change:

.corflags 0x00000001

   to:

.corflags 0x00000002

 - follow this with a VT Fixup Table, as large as the number of routines to export:

.data VT_01 = int32[2]
.vtfixup [2] int32 fromunmanaged at VT_01

 - insert into each method to export a VT entry:

      .vtentry 1:1
      .export [1] as DoSomething

      .vtentry 1:2
      .export [2] as DoSomethingElse
*)

{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Windows.Forms.dll'}

uses
  System.Windows.Forms;

type
  SampleClass = class(&Object)
  public
    class procedure DoSomething(I: Integer); static;
    class procedure DoSomethingElse(const Msg: String); static;
  end;

class procedure SampleClass.DoSomething(I: Integer);
begin
  MessageBox.Show(I.ToString)
end;

class procedure SampleClass.DoSomethingElse(const Msg: String);
begin
  MessageBox.Show(Msg)
end;

//This part won't compile
//exports
//  SampleClass.DoSomething,
//  SampleClass.DoSomethingElse;

begin
end.
